#!/usr/bin/python3
"""Upotreba ./validate.py test/*.in*"""

import string


def check(lines):
	nl = []   # ispravno formatirane linije

	n = int(lines[0])
	assert 1 <= n <= 100, "n kriv"
	k = int(lines[1])
	assert 1 <= k <= n, "k kriv"
	nl.append("{}\n".format(n))
	nl.append("{}\n".format(k))
	
	p = []
	for i in range(k): 
		A = list(map(int, lines[2 + i].strip().split()))
		assert len(A) == n, "broj brojeva u danu != n"
		p.append(A)
		nl.append(('{}' + ' {}'*(n - 1) + '\n').format(*A))

		for ai in A:
			assert 1 <= ai <= 1000000, "ai kriv"

	pob = [0] * n
	curr = [0] * n
	samo_pob = 1
	for i in range(k):
		for j in range(n):
			curr[j] += p[i][j]

		tko = 0
		for j in range(n):
			if p[i][j] > p[i][tko]: tko = j

		if not pob[tko]:
			pob[tko] = 1
			continue
		
		samo_pob = 0
		for j in range(n):
			if pob[tko] or curr[j] > curr[tko] and not pob[j]: tko = j

		pob[tko] = 1

	assert lines == nl, "Krivi format (%s vs %s)" % (lines, nl)
	assert lines[-1][-1] == "\n", "Zadnji red ne zavrsava sa \\n"
	return n, k, samo_pob

# Ocekivani clusteri! Ovo vjerojatno zelis promijeniti!
expected_clusters = {'samo_pob': 6, 'normalni' : 12}

def what_cluster(data):
	n, k, samo_pob = data
	if samo_pob: return 'samo_pob'
	return 'normalni'

################### Zadatak-specifican kod iznad ove linije #########################

import sys
import glob
import hashlib


def group_in_batches(files):
	# mnozenje.in.1a, mnozenje.in.1b sprema u isti batch

	files.sort()
	B = []
	for f in files:
		if f[-1].islower() and len(B) > 0 and f[:-1] == B[-1][-1][:-1]:
			B[-1].append(f)
		else:
			B.append([f])
	return B


if __name__ == "__main__":
	f = []
	for pattern in sys.argv[1:]:
		for filename in glob.glob(pattern):
			f.append(filename)

	bc = []
	for batch in group_in_batches(f):
		if 'dummy' not in batch[0]:
			bc.append([])
			for filename in batch:
				print("{}: ".format(filename), end="")
				try:
					lines = open(filename).readlines()
					summary = check(lines)
					c = what_cluster(summary)
					if 'dummy' not in batch[0]:
						bc[-1].append(c)
				except Exception as e:
					print("Greska!", e)
					raise
				else:
					print("Sve ok! (cluster {}, summary = {})".format(c, summary))
	clusters = {}
	for b in bc:
		for c in b:
			assert c == b[0], "Ima razlicitih cluster-a unutar batcha"
		if not b[0] in clusters:
			clusters[b[0]] = 0
		clusters[b[0]] += 1

	assert clusters == expected_clusters, "Kriva raspodjela clustera ({} vs {})".format(clusters, expected_clusters)

	# Buda test - provjeri duplikate
	hashes = set(hashlib.sha1(open(x, 'rb').read()).hexdigest() for x in f)
	assert len(hashes) == len(f), "Ima duplikata!"
